	function [G, Z, R_ZEROS, P, Wsnew] = CH_II_B_POLES_S(G, Z, P, Wc, Ws, Amax, Amin)
	
	% 	Transforms the poles of an even order analog lowpass Chebyshev II filter of
	% 	type a with cutoff frequency Wc to have two transmission zeros at s = . 
	% 	That is, into a Chebyshev II filter type b.
	% 	The cutoff edge is invariant, only the stopband edge, Ws, is increased.
	% 	R_ZEROS are the reflection zeros and Wsnew is the actual stopband edge frequency.
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
	
	% 	Author: 		Lars Wanhammar, 2008-07-15
	% 	Modified by: 	LW 2014-04-19 
	% 	Copyright:		by authors - not released for commercial use
	% 	Version: 		1
	% 	Known bugs:		
	% 	Report bugs to:	Wanhammar@gmail.com	
	
	% Determine the true stopband edge for the type a filter  can be done nicer!
	delta = (Ws-Wc)/20; Wsa = Wc;
	for n = 1:50
		W = Wsa + delta;
		A = PZ_2_ATT_S(G, Z, P, W);
		if A < Amin
			Wsa = W;
		else
			delta = delta/5;
		end
	end

	Z = sort(Z);
	% Higest transmission zero is
	szmax = max(abs(Z));
	
	% The new stopband edge is
	Wsnew = sqrt(szmax^2-Wc^2)*Wsa/sqrt(szmax^2-Wsa^2);
	
	% The reflection zeros are	
	R_ZEROS = zeros(length(P), 1);
	
	% Remove higest transmission zero pair
	Z(length(Z)) = [];
	Z(length(Z)) = [];
	
	% Transform the remaining zeros
	for n = 1:length(Z)
		Z(n) = sqrt(szmax^2-Wc^2)*Z(n)/sqrt(szmax^2+Z(n)^2);
	end
	Z = flipud(sort(Z));
	
	% Transform the poles
	for n = 1:length(P)
		P(n) = sqrt(szmax^2-Wc^2)*P(n)/sqrt(szmax^2+P(n)^2);
	end

	Apn = Amax*log(10)/20;
	Asn = Amin*log(10)/20;
	epsilon2 = 2*exp(Apn)*sinh(Apn);
	G = real(prod(P)/prod(Z));	% Gain constant
	
